unit fROR_ResultRanges;
{
================================================================================
*
*       Package:        ROR - Clinical Case Registries
*       Date Created:   January 18, 2013
*       Site:           Hines OIFO
*       Developers:     Ed Micyus
*       Description:    Data entry window used to replace TMS advanced column
*                       grid for visually impaired users.
*
*       Notes:
*
================================================================================
}
interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls;

type
  TFormResultRanges = class(TForm)
    btnOK: TButton;
    btnCancel: TButton;
    chkName0: TCheckBox;
    lblLow0: TLabel;
    edtLow0: TEdit;
    edtHigh0: TEdit;
    lblHigh0: TLabel;
    procedure NumberKeyPress(Sender: TObject; var Key: Char);
    procedure FormShow(Sender: TObject);
    procedure edtLowExit(Sender: TObject);
    procedure edtHighExit(Sender: TObject);
    procedure checkBoxClick(Sender: TObject);
  private
    { Private declarations }
    fListData: TStringList;
    fChecks: TStringList;
    fNames:  TStringList;
    fLows: TStringList;
    fHighs: TStringList;
  public
    { Public declarations }
    constructor Create(aList: TStringList; aOwner: TComponent = nil); reintroduce;
    destructor  Destroy; override;

    property ListData: TStringList          read fListData;

    function Edit: integer;
  end;

var
  FormResultRanges: TFormResultRanges;

implementation

uses uROR_Common, uROR_Utilities;

{$R *.dfm}

constructor TFormResultRanges.Create(aList: TStringList; aOwner: TComponent);
var i: integer;
  chk: TCheckBox;
  lbl1, lbl2: TLabel;
  edt1, edt2: TEdit;
begin
  if Assigned(aOwner) then
    inherited Create(aOwner)
  else
    inherited Create(Application);

  fListData := aList;
  fChecks := TStringList.Create;
  fNames := TStringList.Create;
  fLows := TStringList.Create;
  fHighs := TStringList.Create;

  for i := 0 to fListData.Count - 1 do
  begin
    fChecks.Add(Piece(fListData[i], U, 1));
    fNames.Add(Piece(fListData[i], U, 2));
    fLows.Add(Piece(fListData[i], U, 3));
    fHighs.Add(Piece(fListData[i], U, 4));
  end;

  //Load values for first item
  chkName0.Checked := (fChecks[0] = '1');
  chkName0.Caption := fNames[0];
  edtLow0.Text     := fLows[0];
  edtHigh0.Text    := fHighs[0];

  //Create checkboxes, labels and edit controls for the remainder of the list
  for i := 1 to fListData.Count - 1 do
  begin
    chk := TCheckBox.Create(self);
    chk.Name    := Format('chkName%d', [i]);
    chk.Tag     := i;
    chk.Checked := (fChecks[i] = '1');
    chk.Caption := fNames[i];
    chk.Left    := chkName0.Left;
    chk.Top     := chkName0.Top + (i * 29);
    chk.Width   := chkName0.Width;
    chk.OnClick := checkBoxClick;
    chk.Parent  := self;

    lbl1 := TLabel.Create(self);
    lbl1.Name    := Format('lblLow%d', [i]);
    lbl1.Caption := 'Low';
    lbl1.Left    := lblLow0.Left;
    lbl1.Top     := lblLow0.Top + (i * 29);
    lbl1.Parent  := self;

    edt1 := TEdit.Create(self);
    edt1.Name       := Format('edtLow%d', [i]);
    edt1.Tag        := i;
    edt1.Text       := fLows[i];
    edt1.Left       := edtLow0.Left;
    edt1.Top        := edtLow0.Top + (i * 29);
    edt1.Width      := edtLow0.Width;
    edt1.OnKeyPress := NumberKeyPress;
    edt1.OnExit     := edtLowExit;
    edt1.Parent     := self;

    lbl2         := TLabel.Create(self);
    lbl2.Name    := Format('lblHigh%d', [i]);
    lbl2.Caption := 'High';
    lbl2.Left    := lblHigh0.Left;
    lbl2.Top     := lblHigh0.Top + (i * 29);
    lbl2.Parent  := self;

    edt2            := TEdit.Create(self);
    edt2.Name       := Format('edtHigh%d', [i]);
    edt2.Tag        := i;
    edt2.Text       := fHighs[i];
    edt2.Left       := edtHigh0.Left;
    edt2.Top        := edtHigh0.Top + (i * 29);
    edt2.Width      := edtHigh0.Width;
    edt2.OnKeyPress := NumberKeyPress;
    edt2.OnExit     := edtHighExit;
    edt2.Parent     := self;

    self.Height := self.Height + 29;
  end;
end;

destructor TFormResultRanges.Destroy;
begin
  fListData := nil;
  inherited;
end;

procedure TFormResultRanges.FormShow(Sender: TObject);
begin
  chkName0.SetFocus;
end;

function TFormResultRanges.Edit: Integer;
begin
  Result := ShowModal;
end;

//***** Update the data StringList with the changed value.

procedure TFormResultRanges.checkBoxClick(Sender: TObject);
var iTag: integer;
begin
  iTag := (Sender as TCheckBox).Tag;
  if (Sender as TCheckBox).Checked then
    ListData[iTag] := '1' + U + piece(ListData[iTag], U, 2, 4)
  else
    ListData[iTag] := '0' + U + piece(ListData[iTag], U, 2, 4);
end;

//***** Upon exit from the Low or High edit fields, update the data StringList.

procedure TFormResultRanges.edtLowExit(Sender: TObject);
var iTag: integer;
    tmpStr: String;
begin
  iTag := (Sender as TEdit).Tag;
  tmpStr := trim((Sender as TEdit).Text);
  ListData[iTag] := piece(ListData[iTag], U, 1, 2) + U + tmpStr + U +
                    piece(ListData[iTag], U, 4);
  if length(tmpStr) > 0 then
    ListData[iTag] := '1' + U + piece(ListData[iTag], U, 2, 4);
end;

procedure TFormResultRanges.edtHighExit(Sender: TObject);
var iTag: integer;
    tmpStr: String;
begin
  iTag := (Sender as TEdit).Tag;
  tmpStr := trim((Sender as TEdit).Text);
  ListData[iTag] := piece(ListData[iTag], U, 1, 3) + U + tmpStr;
  if length(tmpStr) > 0 then
    ListData[iTag] := '1' + U + piece(ListData[iTag], U, 2, 4);
end;

procedure TFormResultRanges.NumberKeyPress(Sender: TObject; var Key: Char);
begin
  if (not (Key in ['0'..'9','.',#8])) then
    Key := #0;
end;

end.
